package org.apache.slide.projector.processor.process;

import java.util.logging.Logger;

import org.apache.slide.projector.constraints.ConstraintsManager;
import org.jdom.Element;

public class ParameterConfiguration {
    private static Logger logger = Logger.getLogger(ParameterConfiguration.class.getName());

    private String name;
    private Object value;

    public ParameterConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void configure(Element element) {
    	this.value = ConstraintsManager.getInstance().loadValue(element);
    }
    
    public Object getValue() {
    	return value;
    }
}