/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/query/PropertyQuery.java,v 1.5 2004/11/28 13:54:07 dflorey Exp $
 * $Revision: 1.5 $
 * $Date: 2004/11/28 13:54:07 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.ArrayConstraints;
import org.apache.commons.contract.constraints.MapConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.constraints.URIConstraints;
import org.apache.slide.projector.context.ProjectorContext;
import org.apache.slide.projector.value.URIValue;

/**
 * The Query class
 * 
 */
public class PropertyQuery implements Processor {
    private final static String EMPTY = "empty";
    private final static String URI = "uri";
    private final static String ARRAY = "array";
    private final static String MAP = "map";

    private static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] { 
            new ResultDescriptor(StateDescriptor.OK_DESCRIPTOR,
            new ResultEntryDescriptor[] {
                    new ResultEntryDescriptor(ARRAY, new ParameterMessage("propertyQuery/array"), ArrayConstraints.UNCONSTRAINED),
                    new ResultEntryDescriptor(MAP, new ParameterMessage("propertyQuery/map"), MapConstraints.UNCONSTRAINED)
                }),
                new ResultDescriptor(new StateDescriptor(EMPTY, new LocalizedMessage("propertyQuery/state/empty")))
    };

    private static ParameterDescriptor []parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(URI, new ParameterMessage("propertyQuery/uri"), new URIConstraints())
    };

    public Result process(Map parameter, Context context) throws Exception {
    	List properties = Projector.getRepository().getProperties((URIValue)parameter.get(URI), ((ProjectorContext)context).getCredentials());
        if ( properties.size() == 0 ) return new Result(EMPTY);
        Result result= new Result(StateDescriptor.OK, ARRAY, properties);
        Map properyMap = new HashMap();
        for ( Iterator i = properties.iterator(); i.hasNext(); ) {
            Object entry = i.next();
            properyMap.put(((Map)entry).get("name").toString(), ((Map)entry).get("value"));
        }
        result.addResultEntry(MAP, properyMap);
        return result;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}