/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/query/ResourceQuery.java,v 1.5 2004/11/28 13:54:07 dflorey Exp $
 * $Revision: 1.5 $
 * $Date: 2004/11/28 13:54:07 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.query;

import java.util.List;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.ArrayConstraints;
import org.apache.commons.contract.constraints.StringConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.context.ProjectorContext;
import org.apache.slide.projector.processor.SimpleProcessor;

/**
 * The Query class
 * 
 */
public class ResourceQuery implements Processor {
    private final static String EMPTY = "empty";
    private final static String DASL_QUERY = "query";

    private static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            new ResultDescriptor(StateDescriptor.OK_DESCRIPTOR,
                    new ResultEntryDescriptor[] {
                    new ResultEntryDescriptor(SimpleProcessor.OUTPUT, new LocalizedMessage("queryResult"), ArrayConstraints.UNCONSTRAINED)
            }),
            new ResultDescriptor(new StateDescriptor(EMPTY, new LocalizedMessage("resourceQuery/state/empty")))
    };

    private static ParameterDescriptor []parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(DASL_QUERY, new ParameterMessage("daslQuery"), new StringConstraints())
    };

    public Result process(Map parameter, Context context) throws Exception {
        String query = (String)parameter.get(DASL_QUERY);
        List values = Projector.getRepository().search(query, ((ProjectorContext)context).getCredentials());
        if ( values.size() == 0 ) return new Result(EMPTY);
        return new Result(StateDescriptor.OK, SimpleProcessor.OUTPUT, values);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}