package org.apache.slide.projector.processor.security;

import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.context.ProjectorContext;

/**
 * @version $Revision: 1.5 $
 */

public class Authenticated implements Processor {
    private final static String TRUE = "true";
    private final static String FALSE = "false";

    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[0];
    private final static ResultDescriptor []resultDescirptors = new ResultDescriptor[] { 
            new ResultDescriptor(new StateDescriptor(TRUE, new LocalizedMessage("authenticated/state/true"))),
            new ResultDescriptor(new StateDescriptor(FALSE, new LocalizedMessage("authenticated/state/false")))
    };

    public Result process(Map parameter, Context context) throws Exception {
        if ( ((ProjectorContext)context).getCredentials() == Projector.getCredentials() ) {
        	return new Result(FALSE);
        }
        return new Result(TRUE);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
    	return resultDescirptors;
    }
}