package org.apache.slide.projector.processor.security;

import java.util.List;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.constraints.ArrayConstraints;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.descriptor.ResultEntryDescriptor;
import org.apache.commons.contract.descriptor.StateDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.commons.i18n.LocalizedMessage;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.constraints.URIConstraints;
import org.apache.slide.projector.context.ProjectorContext;
import org.apache.slide.projector.value.URI;

/**
 * @version $Revision: 1.5 $
 */

public class ListRoles implements Processor {
    private final static String USER = "user";

    private final static String ROLES = "roles";
    private final static String OK = "ok";
    private final static String FAILED = "failed";

    private final static ParameterDescriptor [] parameterDescriptor = new ParameterDescriptor[] {
            new ParameterDescriptor(USER, new ParameterMessage("listRoles/parameter/user"), new URIConstraints())
        };

    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            new ResultDescriptor(StateDescriptor.OK_DESCRIPTOR,
			new ResultEntryDescriptor[] {
    			new ResultEntryDescriptor(ROLES, new LocalizedMessage("listRoles/result/roles"), ArrayConstraints.UNCONSTRAINED)
    		})
    };

    public Result process(Map parameter, Context context) throws Exception {
        URI user = (URI)parameter.get(USER);
        List roles = Projector.getRepository().listRoles(user, ((ProjectorContext)context).getCredentials());
        return new Result(StateDescriptor.OK, ROLES, roles);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
    	return parameterDescriptor;
    }

    public ResultDescriptor[] getResultDescriptors() {
    	return resultDescriptors;
    }
}