/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/security/RemoveRole.java,v 1.5 2004/11/28 13:54:07 dflorey Exp $
 * $Revision: 1.5 $
 * $Date: 2004/11/28 13:54:07 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.security;

import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Processor;
import org.apache.commons.contract.Result;
import org.apache.commons.contract.descriptor.ParameterDescriptor;
import org.apache.commons.contract.descriptor.ResultDescriptor;
import org.apache.commons.contract.i18n.ParameterMessage;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.constraints.URIConstraints;
import org.apache.slide.projector.context.ProjectorContext;
import org.apache.slide.projector.value.URI;

/**
 * The Event class
 * 
 */
public class RemoveRole implements Processor {
    public final static String USER = "user";
    public final static String ROLE = "role";

    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(USER, new ParameterMessage("addRole/parameter/user"), new URIConstraints()),
        new ParameterDescriptor(ROLE, new ParameterMessage("addRole/parameter/role"), new URIConstraints())
    };
    private final static ResultDescriptor[] resultDescriptors = new ResultDescriptor[] {
            ResultDescriptor.OK
    };

    public Result process(Map parameter, Context context) throws Exception {
    	URI user = (URI)parameter.get(USER);
    	URI role = (URI)parameter.get(ROLE);
    	Projector.getRepository().removeRole(user, role, ((ProjectorContext)context).getCredentials());
    	return Result.OK;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor[] getResultDescriptors() {
        return resultDescriptors;
    }
}