package org.apache.slide.projector.repository;

import java.util.List;
import java.util.Map;

import org.apache.commons.httpclient.Credentials;
import org.apache.slide.projector.value.Streamable;
import org.apache.slide.projector.value.TypedInputStream;
import org.apache.slide.projector.value.URI;
import org.apache.webdav.lib.Subscriber;

/**
 * The Connector interface
 * 
 */
public interface Repository {
	public Credentials login(String user, String password) throws RepositoryException;
		
	public URI createUser(String user, String password, Credentials credentials) throws RepositoryException;
	
	public void deleteUser(URI user, Credentials credentials) throws RepositoryException;
	
	public URI createRole(String role, Credentials credentials) throws RepositoryException;
	
	public void deleteRole(URI role, Credentials credentials) throws RepositoryException;
	
    public List listRoles(URI user, Credentials credentials) throws RepositoryException;

    public void addRole(URI user, URI role, Credentials credentials) throws RepositoryException;
	
	public void removeRole(URI user, URI role, Credentials credentials) throws RepositoryException;
	
	public void changePassword(URI uri, String oldPassword, String newPassword, Credentials credentials) throws RepositoryException;
	
	public TypedInputStream getResource(URI uri, Credentials credentials) throws RepositoryException;

    public List getProperties(URI uri, Credentials credentials) throws RepositoryException;

    public void setResource(URI uri, Streamable resource, Credentials credentials) throws RepositoryException;

    public void removeResource(URI uri, Credentials credentials) throws RepositoryException;

    public List getChildren(URI uri, Credentials credentials) throws RepositoryException;
    
    public List search(String query, Credentials credentials) throws RepositoryException;

    public void subscribe(String method, URI uri, int depth, Subscriber listener, Credentials credentials) throws RepositoryException;

    public void subscribe(String method, URI uri, int depth, int lifetime, int notificationDelay, Subscriber listener, Credentials credentials)  throws RepositoryException;

    public void unsubscribe(URI uri, Subscriber listener, Credentials credentials) throws RepositoryException;

    public void fireEvent(Map information, Credentials credentials) throws RepositoryException;

    public void fireVetoableEvent(Map information, Credentials credentials) throws RepositoryException;
}
