/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/repository/webdav/WebdavException.java,v 1.2 2004/11/28 13:54:07 dflorey Exp $
 * $Revision: 1.2 $
 * $Date: 2004/11/28 13:54:07 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.repository.webdav;

import org.apache.commons.i18n.LocalizedError;
import org.apache.slide.projector.repository.RepositoryException;

public class WebdavException extends RepositoryException {
    private int statusCode;
    
    public WebdavException(LocalizedError errorMessage, int statusCode, Throwable cause) {
        super(errorMessage, cause);
        this.statusCode = statusCode;
    }

    public WebdavException(LocalizedError errorMessage, int statusCode) {
        super(errorMessage);
        this.statusCode = statusCode;
    }
}
