package org.apache.slide.projector.store;

import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;
import org.apache.slide.projector.engine.Scheduler;

public abstract class AbstractStore implements Store {
    private final static Logger logger = Logger.getLogger(AbstractStore.class.getName());
	
	public void put(final String key, Object value, long timeout, final Context context) throws StoreException {
		put(key, value, context);
		Scheduler.getTimer().schedule(new TimerTask() {
			public void run() {
				try {
					dispose(key, context);
				} catch ( StoreException exception ) {
					logger.log(Level.SEVERE, "Could not dispose object with key="+key, exception);
				}
			}
		}, timeout);
	}
}
