package org.apache.slide.projector.store;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.StoreException;

public class Cache extends AbstractStore {
    public final static String ID = "cache";
    
    private static Cache cache = new Cache();
    private Map map;

    public static Cache getInstance() {
        return cache;
    }

    public Cache() {
    	map = new HashMap();
    }
    
    public void setMap(Map map) {
    	this.map = map;
    }
    
    public Map getMap() {
    	return map;
    }
    
    public void put(String key, Object value, Context context) throws StoreException {
        map.put(key, value);
    }

    public Object get(String key, Context context) throws StoreException {
        return map.get(key);
    }

    public void dispose(String key, Context context) throws StoreException {
        map.remove(key);
    }

    public String getId() {
        return ID;
    }
}