/*
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.projector.store;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;
import org.apache.commons.i18n.LocalizedError;
import org.apache.slide.projector.context.ProjectorContext;
import org.apache.slide.projector.value.URI;

public class FormStore extends AbstractStore {
    public final static String ID = "form";

	private ProjectorContext context;
	private Store store;
	
	public FormStore(ProjectorContext context, Store store) {
		this.context = context;
		this.store = store;
	}

	public void put(String key, Object value, Context context) throws StoreException {
		getDomain().put(key, value);
	}

	public Object get(String key, Context context) throws StoreException {
		return getDomain().get(key);
	}

	public void dispose(String key, Context context) throws StoreException {
		getDomain().remove(key);
	}

	public void clear(Context context) throws StoreException {
        if ( context instanceof ProjectorContext ) {
            URI process = ((ProjectorContext)context).getProcess();
            String domain = process.toString();
            store.dispose(domain, context);
        } else {
            throw new StoreException(new LocalizedError("processRequired"));
        }
	}
	
	public Map getDomain() throws StoreException {
		String domain = context.getProcess().toString();
		Map map = (Map)store.get(domain, context);
		if ( map == null ) {
			map = new HashMap();
			store.put(domain, map, context);
			return map;
		} else {
			return map;
		}
	}

    public String getId() {
        return ID;
    }
}