/*
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.projector.store;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;
import org.apache.slide.projector.Projector;

public class ProcessStore extends AbstractStore {
    public final static String ID = "process";

    private final static String STORAGE_PREFIX = "process/";

    private Store store;
	private String processId, storageKey;
	private Map map;
	
	public ProcessStore(Store store) {
		this.store = store;
	}
	
	public String getProcessId() {
		return processId;
	}

	public void setProcessId(String processId) {
		this.processId = processId;
		this.storageKey = Projector.getWorkDir()+STORAGE_PREFIX+processId;
	}

	public void put(String key, Object value, Context context) throws StoreException {
		getMap(context).put(key, value);
		store.put(storageKey, map, context);
	}

	public Object get(String key, Context context) throws StoreException {
		return getMap(context).get(key);
	}

	public void dispose(String key, Context context) throws StoreException {
		getMap(context).remove(key);
		store.put(storageKey, map, context);
	}
	
	private Map getMap(Context context) throws StoreException {
		if ( map == null ) {
		    map = (Map)store.get(storageKey, context);
		    if ( map == null ) {
		        map = new HashMap();
		    }
        }
        return map;
	}

    public String getId() {
        return ID;
    }
}