/*
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.projector.store;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;
import org.apache.commons.i18n.LocalizedError;

public class RequestParameterStore implements Store {
    public final static String ID = "requestParameter";

    protected HttpServletRequest request;

    public RequestParameterStore(HttpServletRequest request) {
        this.request = request;
    }

    public void put(String key, Object value, long timeout, Context context) throws StoreException {
        throw new StoreException(new LocalizedError("putNotSupported", new String[] { ID }));
    }

    public void put(String key, Object value, Context context) throws StoreException {
        throw new StoreException(new LocalizedError("putNotSupported", new String[] { ID }));
    }

    public Object get(String key, Context context) {
        return request.getParameterValues(key);
    }

    public void dispose(String key, Context context) throws StoreException {
        throw new StoreException(new LocalizedError("disposeNotSupported", new String[] { ID }));
    }

    public String getId() {
        return ID;
    }
}