/*
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.projector.store;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.contract.Context;

public class SessionStore extends AbstractStore {
    public final static String ID = "session";

    protected HttpServletRequest request;

    public SessionStore(HttpServletRequest request) {
        this.request = request;
    }

    public void put(String key, Object value, Context context) {
        HttpSession session = request.getSession();
        if ( session == null ) return;
        session.setAttribute(key, value);
    }

    public Object get(String key, Context context) {
        HttpSession session = request.getSession();
        if ( session == null ) return null;
        return session.getAttribute(key);
    }

    public void dispose(String key, Context context) {
        HttpSession session = request.getSession();
        if ( session == null ) return;
        session.removeAttribute(key);
    }

    public String getId() {
        return ID;
    }
}