package org.apache.slide.projector.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.contract.Context;
import org.apache.commons.contract.Store;
import org.apache.commons.contract.StoreException;

public class StoreHelper {
    private static Logger logger = Logger.getLogger(StoreHelper.class.getName());

    public static Object get(Store store, String domain, String key, Context context) {
    	try {
    		Map map = (Map)store.get(domain, context);
    		if ( map != null ) {
    			return map.get(key);
    		}
    	} catch ( StoreException exception ) {
    		logger.log(Level.SEVERE, "Error while accessing store", exception);
    	}
    	return null;
    }

    public static void put(Store store, String domain, String key, Object value, Context context) {
    	try {
    		Map map = (Map)store.get(domain, context);
    		if ( map != null ) {
    			map.put(key, value);
    		} else {
    			map = new HashMap();
                map.put(key, value);
    			store.put(domain, map, context);
    		}
    	} catch ( StoreException exception ) {
    		logger.log(Level.SEVERE, "Error while accessing store", exception);
    	}
    }
}