/*
 * $Header: /home/cvspublic/jakarta-slide/projector/src/java/org/apache/slide/projector/value/AbstractStreamable.java,v 1.2 2004/11/28 13:54:08 dflorey Exp $
 * $Revision: 1.2 $
 * $Date: 2004/11/28 13:54:08 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.value;

import java.util.logging.Logger;

import org.apache.commons.xmlio.out.XMLEncode;
import org.apache.commons.xmlio.out.XMLStringWriter;
import org.apache.commons.xmlio.out.XMLWriter;
import org.apache.slide.projector.repository.RepositoryException;
import org.apache.slide.projector.util.StreamHelper;

/**
 * The AbstractStreamableResource class
 * 
 */
public abstract class AbstractStreamable implements Streamable {
    private static Logger logger = Logger.getLogger(AbstractStreamable.class.getName());

    public String toString() {
        try {
            return StreamHelper.streamToString(this);
        } catch (RepositoryException e) {
            return null;
        }
    }
    
    public void save(XMLStringWriter writer) {
        try {
            writer.writeElementWithPCData(XMLWriter.createStartTag("value"), XMLEncode.xmlEncodeText(StreamHelper.streamToString(this)), XMLWriter.createEndTag("value"));
        } catch (RepositoryException e) {
            writer.writeEmptyElement(XMLWriter.createEmptyTag("value"));
        }
    }
}
