package org.apache.slide.projector.value;

import java.util.Locale;

import org.apache.commons.i18n.MessageManager;
import org.apache.commons.i18n.MessageNotFoundException;

public class MessageValue {
    public final static String ID = "id";
    public final static String ARGUMENTS = "arguments";

    protected String id;
    protected Object[] arguments;

    public MessageValue(String messageId) {
        this.id = messageId;
        this.arguments = new Object[0];
    }

    public MessageValue(String messageId, Object[] arguments) {
        this.id = messageId;
        this.arguments = arguments;
    }

    public String getId() {
        return id;
    }

    public Object[] getArguments() {
    	return arguments;
    }
    
    public String getText(String key, Locale locale) throws MessageNotFoundException {
        return MessageManager.getText(id, key, arguments, locale);
    }

    public String getText(String key, String defaultText, Locale locale) {
        return MessageManager.getText(id, key, arguments, locale, defaultText);
    }
}