package org.apache.slide.projector.value;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.apache.slide.projector.repository.RepositoryException;
import org.apache.slide.projector.util.StreamHelper;

/**
 * @version $Revision: 1.1 $
 */

public class MultipleStreamable extends AbstractStreamable {
    private Streamable value;
    private byte[] bytes;

    public MultipleStreamable(Streamable resource) {
        this.value = resource;
    }

    public InputStream getInputStream() throws RepositoryException {
        if ( bytes == null ) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamHelper.copy(value.getInputStream(), outputStream);
            bytes = outputStream.toByteArray();
        }
        return new ByteArrayInputStream(bytes);
    }

    public int getContentLength() {
        return value.getContentLength();
    }

    public boolean isDocument() {
        return value.isDocument();
    }

    public String getCharacterEncoding() {
        return value.getCharacterEncoding();
    }
}
