package org.apache.slide.projector.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import org.apache.commons.i18n.LocalizedError;
import org.apache.slide.projector.ContentType;
import org.apache.slide.projector.repository.RepositoryException;

public class Text implements Streamable {
	public static final Text EMPTY = new Text("");

    private String content;
	private boolean isDocument;
    private String contentType = "text/plain";

    public Text(String content) {
        this.content = content;
        contentType = ContentType.determineContentType(content);
        isDocument = ContentType.determineIsDocument(content);
    }

    public Text(String content, boolean document) {
        this.content = content;
        contentType = ContentType.determineContentType(content);
        isDocument = document;
    }

    public Text(String content, String contentType, boolean document) {
        this.content = content;
        this.isDocument = document;
        this.contentType = contentType;
    }

    public InputStream getInputStream() throws RepositoryException {
        try {
            return new ByteArrayInputStream(content.getBytes("UTF-8"));
        } catch ( UnsupportedEncodingException exception ) {
            throw new RepositoryException(new LocalizedError("UnsupportedEncodingException"), exception);
        }
    }

    public String toString() {
        return content;
    }

    public boolean isDocument() {
        return isDocument;
    }

    public int getContentLength() {
        return toString().length();
    }

    public String getContentType() {
        return contentType;
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }
}