package org.apache.slide.projector.value;

import java.io.InputStream;

import org.apache.slide.projector.repository.RepositoryException;

public class TypedInputStream extends AbstractStreamable {
    private boolean isDocument;
    private String contentType, characterEncoding;
    private InputStream stream;
    private int contentLength;

    public TypedInputStream(InputStream stream, String contentType, String characterEncoding, int contentLength, boolean document) {
        isDocument = document;
        this.stream = stream;
        this.contentType = contentType;
        this.characterEncoding = characterEncoding;
        this.contentLength = contentLength;
    }

    public InputStream getInputStream() throws RepositoryException {
        return stream;
    }

    public boolean isDocument() {
        return isDocument;
    }

    public int getContentLength() {
        return contentLength;
    }

    public String getContentType() {
        return contentType;
    }

    public String getCharacterEncoding() {
        return characterEncoding;
    }
}