package org.apache.slide.projector.value;


public class URIValue implements URI {
    private String uri;
    
    public URIValue(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return uri;
    }
    
    public boolean startsWith(URI uri) {
        return toString().startsWith(uri.toString());
    }

    public boolean isRelative() {
        String uri = toString();
        return (uri != null && uri.length() > 0 && uri.charAt(0) != '/');
    }

    public boolean equals(Object o) {
        return (this == o || (o != null && o instanceof URIValue && ((URIValue)o).toString().equals(toString())));
    }

    public int hashCode() {
        return toString().hashCode();
    }
}