/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/bean/DomainBean.java,v 1.3 2004/07/30 06:51:47 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:47 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.bean;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideToken;

/**
 * Wraps around the Slide domain and provides a Java Bean style interface for 
 * accessing the defined namespace(s).
 * 
 * <p>This class is intended to be used in the context of web presentation 
 * layer technologies such as JSP or Velocity.</p>
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class DomainBean
    extends AbstractBean {
    
    
    // ----------------------------------------------------------- Construction
    
    
    /**
     * Default Constructor.
     */
    public DomainBean() {
        super();
        
    }
    
    
    /**
     * Constructor.
     * 
     * @param st the slide token
     */
    public DomainBean(SlideToken st) {
        super(null, st);
        
    }
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Returns a NamespaceBean representing the default namespace.
     *
     * @return NamespaceBean representing the default namespace.
     * 
     * @see #getDefaultNamespaceName
     */
    public NamespaceBean getDefaultNamespace() {
        
        String name = Domain.getDefaultNamespace();
        if (name != null) {
            return getNamespace(name);
        }
        
        return null;
    }
    
    
    /**
     * Returns the name of the default namespace.
     *
     * @return a String containing the name of the default namespace
     * 
     * @see #getDefaultNamespace
     */
    public String getDefaultNamespaceName() {
        
        return Domain.getDefaultNamespace();
    }
    
    
    /**
     * Returns a Vector of NamespaceBeans representing all the namespaces
     * in the Slide domain.
     *
     * @return a list of NamespaceBean objects
     * 
     * @see #getNamespaceNames
     */
    public List getNamespaces() {
        
        List namespaces = new ArrayList();
        Enumeration enum = Domain.enumerateNamespaces();
        while (enum.hasMoreElements()) {
            String name = (String)enum.nextElement();
            NamespaceBean bean = getNamespace(name);
            if (bean != null) {
                namespaces.add(bean);
            }
        }
        
        return namespaces;
    }
    
    
    /**
     * Returns the names of all namespaces defined in the Slide domain.
     *
     * @return a List of String objects, each of which containing the name of a 
     *         namespace
     * 
     * @see #getNamespaces
     */
    public List getNamespaceNames() {
        
        List names = new ArrayList();
        Enumeration enum = Domain.enumerateNamespaces();
        while (enum.hasMoreElements()) {
            names.add((String)enum.nextElement());
        }
        
        return names;
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns a NamespaceBean representing the namespace with the specified
     * name, or <code>null</code> if that namespace is not available.
     * 
     * @param name the name of the namespace to access
     * 
     * @return NamespaceBean representing the requested namespace
     */
    public NamespaceBean getNamespace(String name) {
        
        NamespaceBean bean = null;
        NamespaceAccessToken token = 
            Domain.accessNamespace(new SecurityToken(this), name);
        if (token != null) {
            bean = new NamespaceBean(token, st);
        }
        
        return bean;
    }
    
    
}


