/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/bean/LockBean.java,v 1.3 2004/07/30 06:51:47 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:47 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. the names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.bean;

import java.util.Date;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideToken;
import org.apache.slide.lock.NodeLock;

/**
 * Wraps around a NodeLock, providing easy, Java Bean style access to the 
 * NodeLock's properties.
 *
 * <p>This class is intended to be used in the context of web presentation 
 * layer technologies such as JSP or Velocity.</p>
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class LockBean
    extends AbstractBean {
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * The wrapped lock object.
     */
    private NodeLock lock;
    
    
    // ----------------------------------------------------------- Construction
    
    
    /**
     * Default constructor.
     */
    public LockBean() {
        super();
        
    }
    
    
    /**
     * Constructor.
     *
     * @param nat the namespace access token
     * @param st the slide token
     * @param lock the NodeLock to wrap
     */
    public LockBean(NamespaceAccessToken nat, SlideToken st, NodeLock lock) {
        super(nat, st);
        
        setNodeLock(lock);
    }
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Returns the expiration date of the lock.
     *
     * @return the expiration date
     */
    public Date getExpirationDate() {
        
        return lock.getExpirationDate();
    }
    
    
    /**
     * Returns the unique identifier of the lock.
     *
     * @return unique identifier of the lock
     */
    public String getId() {
        
        return lock.getLockId();
    }
    
    
    /**
     * Determines whether the lock is exclusive.
     *
     * @return true if the lock is exclusive, false if not
     * 
     * @see #getIsShared
     */
    public boolean getIsExclusive() {
        
        return lock.isExclusive();
    }
    
    
    /**
     * Determines whether the lock is shared.
     * 
     * @return true if the lock is shared, false if not
     * 
     * @see #getIsExclusive
     */
    public boolean getIsShared() {
        
        return lock.isShared();
    }
    
    
    /**
     * Returns the URI of the object that is locked by the lock.
     *
     * @return the URI of the locked object
     */
    public String getObjectUri() {
        
        return lock.getObjectUri();
    }
    
    
    /**
     * Returns the URI of the subject that owns the lock.
     *
     * @return the URI of the lock owner
     */
    public String getSubjectUri() {
        
        return lock.getSubjectUri();
    }
    
    
    /**
     * Return the type of lock, as URI of the corresponding ActionNode.
     * For example, &quot;/actions/write&quot; represents a write lock.
     *
     * @return the URI of the ActionNode that represents the type of lock
     */
    public String getTypeUri() {
        
        return lock.getTypeUri();
    }
    
    
    /**
     * Sets the lock object this bean wraps around.
     *
     * @param lock the NodeLock to wrap
     */
    public void setNodeLock(
        NodeLock lock) {
        
        this.lock = lock;
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns a String representation of the lock.
     *
     * @return a String representation of the lock
     */
    public String toString() {
        
        return lock.toString();
    }
    
    
}


