/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/bean/NamespaceBean.java,v 1.3 2004/07/30 06:51:47 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:47 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. the names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.bean;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.Structure;

/**
 * Wraps around a particular Slide namespace, and provides easy access to the 
 * properties of that namespace and the corresponding configuration.
 * 
 * <p>This class is intended to be used in the context of web presentation 
 * layer technologies such as JSP or Velocity.</p>
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class NamespaceBean
    extends AbstractBean {
    
    
    // ----------------------------------------------------------- Construction
    
    
    /**
     * Default Constructor.
     */
    public NamespaceBean() {
        super();
        
    }
    
    
    /**
     * Constructor.
     * 
     * @param nat the namespace access token
     * @param st the slide token
     */
    public NamespaceBean(NamespaceAccessToken nat, SlideToken st) {
        super(nat, st);
        
    }
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Returns the name of the namespace
     *
     * @return a String containing the name of the namespace
     */
    public String getName() {
        
        return nat.getName();
    }
    
    
    /**
     * Returns the files path as specified in the namespace configuration.
     * 
     * @return a String containing the files path
     */
    public String getFilesPath() {
        
        String filesPath = "";
        NamespaceConfig config = nat.getNamespaceConfig();
        if (config != null) {
            filesPath = config.getFilesPath();
        }
        
        return filesPath;
    }
    
    
    /**
     * Returns the guest user path as specified in the namespace configuration.
     * 
     * @return a String containing the guest path
     */
    public String getGuestPath() {
        
        String guestPath = "";
        NamespaceConfig config = nat.getNamespaceConfig();
        if (config != null) {
            guestPath = config.getGuestPath();
        }
        
        return guestPath;
    }
    
    
    /**
     * Returns the users path as specified in the namespace configuration.
     * 
     * @return a String containing the users path
     */
    public String getUsersPath() {
        
        String usersPath = "";
        NamespaceConfig config = nat.getNamespaceConfig();
        if (config != null) {
            usersPath = config.getUsersPath();
        }
        
        return usersPath;
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns a particular node in the namespace, identified by URI.
     * 
     * @param uri URI of the node to retrieve
     * @param resolveLinks whether links should be resolved when retrieving the
     *        node
     * 
     * @return a NodeBean representing the requested node, or <code>null</code>
     *         if the node could not be found or accessed
     * 
     * @exception SlideException if an exception occurrs in Slide when 
     *            retrieving the node
     */
    public NodeBean getNode(String uri, boolean resolveLinks)
        throws SlideException {
        
        Structure structure = nat.getStructureHelper();
        ObjectNode node = structure.retrieve(st, uri, resolveLinks);
        return new NodeBean(nat, st, node);
    }
    
    
    /**
     * Returns a String representation of the namespace, which is the 
     * namespace's name.
     *
     * @return the namespace name
     */
    public String toString() {
        
        return getName();
    }
    
    
}


