/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/bean/PermissionBean.java,v 1.3 2004/07/30 06:51:47 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:47 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. the names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.bean;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideToken;
import org.apache.slide.security.NodePermission;

/**
 * Wraps around a NodePermission object and provides Java Bean style property
 * accessors.
 *
 * <p>This class is intended to be used in the context of web presentation 
 * layer technologies such as JSP or Velocity.</p>
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class PermissionBean
    extends AbstractBean {
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * The wrapped permission object.
     */
    private NodePermission permission;
    
    
    // ----------------------------------------------------------- Construction
    
    
    /**
     * Default constructor.
     */
    public PermissionBean() {
        super();
        
    }
    
    
    /**
     * Constructor.
     *
     * @param nat the namespace access token
     * @param st the slide token
     * @param permission the NodePermission to wrap
     */
    public PermissionBean(
        NamespaceAccessToken nat,
        SlideToken st,
        NodePermission permission) {
        super(nat, st);
        
        setNodePermission(permission);
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns the URI of the ActionNode associated with the permission.
     *
     * @return the action URI
     */
    public String getActionUri() {
        
        return permission.getActionUri();
    }
    
    
    /**
     * Returns whether the permission is inheritable.
     *
     * @return true if the permission is inheritable, false otherwise
     */
    public boolean getIsInheritable() {
        
        return permission.isInheritable();
    }
    
    
    /**
     * Returns whether the permission is negative (denied).
     *
     * @return true if the permission is negative, false otherwise
     */
    public boolean getIsNegative() {
        
        return permission.isNegative();
    }
    
    
    /**
     * Returns the URI of the ObjectNode referenced by the permission.
     *
     * @return the object URI
     */
    public String getObjectUri() {
        
        return permission.getObjectUri();
    }
    
    
    /**
     * Returns the URI of the SubjectNode associated with the permission.
     *
     * @return the subject URI
     */
    public String getSubjectUri() {
        
        return permission.getSubjectUri();
    }
    
    
    /**
     * Returns the permission this bean wraps around.
     *
     * @return the wrapped NodePermission
     */
    public NodePermission getNodePermission() {
        
        return permission;
    }
    
    
    /**
     * Sets the permission this bean wraps around.
     *
     * @param permission the NodePermission to wrap
     */
    public void setNodePermission(
        NodePermission permission) {
        
        this.permission = permission;
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns a String representation of the permission.
     *
     * @return a String representation of the permission
     */
    public String toString() {
        
        return permission.toString();
    }
    
    
}


