/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/bean/PropertyBean.java,v 1.3 2004/07/30 06:51:47 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:47 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. the names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.bean;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeProperty;

/**
 * Provides a Java Bean style interface for a Slide NodeProperty object.
 *
 * <p>This class is intended to be used in the context of web presentation 
 * layer technologies such as JSP or Velocity.</p>
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class PropertyBean
    extends AbstractBean {
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * The wrapped NodeProperty object.
     */
    private NodeProperty property;
    
    
    // ----------------------------------------------------------- Construction
    
    
    /**
     * Default constructor.
     */
    public PropertyBean() {
        super();
        
    }
    
    
    /**
     * Constructor.
     *
     * @param nat the namespace access token
     * @param st the slide token
     * @param property the property to wrap
     */
    public PropertyBean(NamespaceAccessToken nat, SlideToken st,
                        NodeProperty property) {
        super(nat, st);
        
        this.property = property;
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns the name of the property.
     *
     * @return the property name (local name)
     */
    public String getName() {
        
        return property.getName();
    }
    
    
    /**
     * Returns the namespace of the property.
     *
     * @return the property namespace
     */
    public String getNamespace() {
        
        return property.getNamespace();
    }
    
    
    /**
     * Returns the value of the property as String.
     *
     * @return a String containing the property value
     */
    public String getValue() {
        
        return property.getValue().toString();
    }
    
    
    /**
     * Returns the property this bean wraps around.
     *
     * @return the wrapped NodeProperty to wrap.
     */
    public NodeProperty getNodeProperty() {
        
        return property;
    }
    
    
    /**
     * Sets the property this bean wraps around.
     *
     * @param property the NodeProperty to wrap.
     */
    public void setNodeProperty(
        NodeProperty property) {
        
        this.property = property;
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Returns a String representation of the property.
     *
     * @return a String representation of the property
     */
    public String toString() {
        
        return property.toString();
    }
    
    
}


