/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/tag/ContentTagSupport.java,v 1.3 2004/07/30 06:51:48 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:48 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.tag;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.IOException;
import java.io.Reader;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.slide.common.SlideException;
import org.apache.slide.taglib.bean.NodeBean;
import org.apache.slide.taglib.bean.PropertyBean;
import org.apache.slide.taglib.bean.RevisionBean;

/**
 * Very simple implementation of a tag that includes the content of a revision
 * in the response. Alternatively, the content may be stored as String or 
 * Reader in the page context 
 * 
 * <p>The node and revision is chosen based on the tags the content tag is
 * nested in.</p>
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public abstract class ContentTagSupport
    extends TagSupport {
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * The revision bean.
     */
    protected RevisionBean revision;
    
    
    /**
     * Name of the PageContext attribute under which the String is stored.
     **/
    protected String attrName;
    
    
    /**
     * Name of the PageContext attribute under which the Reader is stored.
     **/
    protected String attrNameReader;
    
    
    /**
     * 
     */
    private Reader reader;
    
    
    // ----------------------------------------------------------- Construction
    
    
    /**
     * Initialize inherited and local state.
     */
    public ContentTagSupport() {
        super();
        
        init();
    }
    
    
    // ------------------------------------------------------------ Tag Methods
    
    
    /**
     * Called by the JSP Engine when opening this tag.
     *
     * @throws JspException If this tag isn't nested inside a NodeTag or a
     *                      NodeWrapper iteration
     */
    public int doStartTag()
        throws JspException {
        
        // revision not found
        if (revision == null) {
            return SKIP_BODY;
        }
        
        try {
            reader = revision.getReader();
            if (attrNameReader != null) {
                pageContext.setAttribute(attrNameReader, reader);
            } else {
                BufferedReader br = new BufferedReader(reader);
                StringBuffer sb = new StringBuffer();
                int i;
                while ((i = reader.read()) != -1) {
                    sb.append((char)i);
                }
                if (attrName != null) {
                    pageContext.setAttribute(attrName, sb.toString());
                } else {
                    pageContext.getOut().print(sb);
                }
            }
        } catch (IOException e) {
            throw new JspException(e.getMessage());
        } catch (SlideException e) {
            throw new JspException(e.getMessage());
        }
        
        return SKIP_BODY;
    }
    
    
    /**
     * Called by the JSP Engine when closing this tag.
     *
     * @throws JspException 
     */
    public int doEndTag()
        throws JspException {
        
        try {
            // If we exposed a Reader in doStartTag(), remove it.
            if (attrNameReader != null) {
                pageContext.removeAttribute(attrNameReader);
            }
            // reader can be null if an exception was thrown...
            if (reader != null) {
                reader.close();
            }
        } catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        
        return EVAL_PAGE;
    }
    
    
    /**
     * Releases any resources we may have (or inherit).
     */
    public void release() {
        super.release();
        
        init();
    }
    
    
    // -------------------------------------------------------- Private Methods
    
    
    /**
     * Reset internal state.
     */
    private void init() {
        
        revision = null;
        attrName = null;
        attrNameReader = null;
    }
    
    
}

