/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/tag/SetNamespaceTagSupport.java,v 1.3 2004/07/30 06:51:48 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:48 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.taglib.tag;

import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.slide.taglib.bean.DomainBean;
import org.apache.slide.taglib.bean.NamespaceBean;
import org.apache.slide.taglib.util.Scopes;

/**
 * Abstract foundation for tags that expose a Slide namespace as a 
 * {@link org.apache.slide.taglib.bean.NamespaceBean NamespaceBean} scripting 
 * variable.
 *
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class SetNamespaceTagSupport
    extends TagSupport {
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * The associated bean that represents the namespace chosen by the 
     * namespace tag, and that will optionally be put in the PageContext 
     * attributes.
     */
    protected NamespaceBean namespace;
    
    
    /**
     * Value of 'name' tag attribute, which specifies the name of the 
     * namespace to choose.
     */
    protected String name;
    
    
    /**
     * Name of the PageContext attribute under which the bean should be stored.
     */
    protected String attrName;
    
    
    /**
     * Scope where the PageContext should be stored.
     */
    private int scope;
    
    
    // ----------------------------------------------------------- Constructors 
    
    
	/**
	 * Constructor for SetNamespaceTagSupport.
	 */
	public SetNamespaceTagSupport() {
		super();
        
        init();
	}
    
    
    // ---------------------------------------------- TagSupport Implementation
    
    
    /**
     * Called by the JSP Engine when closing of this tag.
     *
     * @throws JspException Not thrown
     */
    public int doEndTag()
        throws JspException {
        
        if (namespace != null) {
            pageContext.setAttribute(attrName, namespace, scope);
        }
        init();
        
        return EVAL_PAGE;
    }

    
    /**
     * Releases any resources we may have (or inherit).
     */
    public void release() {
        super.release();
        
        init();
    }
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Sets the 'name' attribute.
     *
     * @param name the attribute value
     */
    public void setName(String name) {
        
        this.name = name;
    }
    
    
    /**
     * Sets the 'scope' attribute.
     * 
     * @param scope the attribute value
     */
    public void setScope(String scope) {
        
        this.scope = Scopes.valueOf(scope);
    }
    
    
    // ------------------------------------------------------ Protected Methods
    
    
    /**
     * Convenience method to support subclasses in retrieving the chosen 
     * namespace, and wrapping it in a 
     * {@link org.apache.slide.taglib.bean.NamespaceBean NamespaceBean}.
     * 
     * @param domain the bean representing the domain
     * @param name the name of the namespace
     */
    protected NamespaceBean getNamespace(DomainBean domain, String name) {
        
        NamespaceBean bean = null;
        
        if (name == null) {
            // look for a 'namespace' context parameter, and use its value
            // as namespace name if present
            ServletContext context = pageContext.getServletContext();
            name = (String) context.getAttribute
                ("org.apache.slide.NamespaceName");
        }
        if (name == null) {
            // look for a 'namespace' context parameter, and use its value
            // as namespace name if present
            ServletContext context = pageContext.getServletContext();
            name = context.getInitParameter
                ("org.apache.slide.NamespaceName");
        }
        if (name == null) {
            // use the default namespace
            name = domain.getDefaultNamespaceName();
        }
        
        if (name != null) {
            bean = domain.getNamespace(name);
            setName(name);
        }
        
        return bean;
    }
    
    
    // -------------------------------------------------------- Private Methods
    
    
    /**
     * Reset internal state.
     */
    private void init() {
        
        name = null;
        attrName = null;
        scope = PageContext.PAGE_SCOPE;
    }
    
    
}
