/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/tag/SetRevisionTagSupport.java,v 1.3 2004/07/30 06:51:48 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:48 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. the names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.tag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.taglib.bean.NodeBean;
import org.apache.slide.taglib.bean.RevisionBean;
import org.apache.slide.taglib.util.Scopes;

/**
 * Abstract foundation for tags that serve to select a revision of an object, 
 * and expose a corresponding
 * {@link org.apache.slide.taglib.bean.RevisionBean RevisionBean} as scripting 
 * variable.
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public abstract class SetRevisionTagSupport
    extends TagSupport {
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * The associated bean that will be put in the PageContext attributes.
     */
    protected RevisionBean revision;
    
    
    /**
     * Value of 'number' attribute.
     */
    protected String number;
    
    
    /**
     * Value of 'branch' attribute.
     */
    protected String branch;
    
    
    /**
     * Name of the PageContext attribute under which the bean is stored.
     */
    protected String attrName;
    
    
    /**
     * Scope where the PageContext should be stored.
     */
    private int scope;
    
    
    // ----------------------------------------------------------- Construction
    
    
    /**
     * Initialize inherited and local state.
     */
    public SetRevisionTagSupport() {
        super();
        
        init();
    }
    
    
    // ------------------------------------------------------------ Tag Methods
    
    
    /**
     * Called by the JSP Engine when closing of this tag.
     *
     * @throws JspException Not thrown
     */
    public int doEndTag()
        throws JspException {
        super.doEndTag();
        
        if (revision != null) {
            pageContext.setAttribute(attrName, revision, scope);
        }
        init();
        
        return EVAL_PAGE;
    }
    
    
    /**
     * Releases any resources we may have (or inherit).
     */
    public void release() {
        super.release();
        
        init();
    }
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Sets the 'number' attribute.
     *
     * @param number the attribute value
     */
    public void setNumber(String number) {
        
        this.number = number;
    }
    
    
    /**
     * Sets the 'branch' attribute.
     *
     * @param branch the attribute value
     */
    public void setBranch(String branch) {
        
        this.branch = branch;
    }
    
    
    /**
     * Sets the 'scope' attribute.
     * 
     * @param scope the attribute value
     */
    public void setScope(String scope) {
        
        this.scope = Scopes.valueOf(scope);
    }
    
    
    // ------------------------------------------------------ Protected Methods
    
    
    /**
     * Convenience method to support subclasses in getting a specific revision 
     * of a node, and wrapping it in a 
     * {@link org.apache.slide.taglib.bean.RevisionBean RevisionBean}.
     * 
     * <p>Either specify the <code>number</code> or the <code>branch</code> 
     * argument. If both are specified, the <code>number</code> argument takes 
     * precedence.</p>
     * 
     * @param node the node of which the revision should be retrieved
     * @param number version number of the revision to retrieve
     * @param branch name of the branch of which to retrieve the latest 
     *        revision
     */
    protected RevisionBean getRevision(NodeBean node, 
                                       NodeRevisionNumber number,
                                       String branch) {
        if (node == null) {
            throw new NullPointerException();
        }
        
        RevisionBean bean = null;
        if (number != null) {
            bean = node.getRevision(number);
        } else if ((branch != null) && (branch.length() > 0)) {
            bean = node.getRevision(branch);
        } else {
            bean = node.getLatestRevision();
        }
        
        return bean;
    }
    
    
    // -------------------------------------------------------- Private Methods
    
    
    /**
     * Reset internal state.
     */
    private void init() {
        
        revision = null;
        number = null;
        branch = null;
        attrName = null;
        scope = PageContext.PAGE_SCOPE;
    }
    
    
}


