/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/common/org/apache/slide/taglib/util/Scopes.java,v 1.3 2004/07/30 06:51:49 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:49 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.taglib.util;

import javax.servlet.jsp.PageContext;

/**
 * Class with utility functions to manage scopes in tags.
 *
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class Scopes {
    
    
    // -------------------------------------------------------------- Constants
    
    
    /**
     * String representation of the page scope ("page").
     */
    public static final String PAGE =
        "page";   
    
    
    /**
     * String representation of the request scope ("request").
     */
    public static final String REQUEST =
        "request";   
    
    
    /**
     * String representation of the session scope ("session").
     */
    public static final String SESSION =
        "session";   
    
    
    /**
     * String representation of the application scope ("application").
     */
    public static final String APPLICATION =
        "application"; 
    
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Constructor hidden to guarantee non-instatiability.
     */
    private Scopes() {
        
    }
    
    
    // -------------------------------------------------- Public Static Methods
    
    
    /**
     * Returns the value of the JSP PageContext integer constant representation 
     * of the scope identified by name.
     * 
     * @param scopeName the name of the scope
     * @return integer value representing the scope, as defined in PageContext
     */
    public static int valueOf(String scopeName) {
        
        int scope = PageContext.PAGE_SCOPE;
        if (REQUEST.equalsIgnoreCase(scopeName)) {
            scope = PageContext.REQUEST_SCOPE;
        } else if (SESSION.equalsIgnoreCase(scopeName)) {
            scope = PageContext.SESSION_SCOPE;
        } else if (APPLICATION.equalsIgnoreCase(scopeName)) {
            scope = PageContext.APPLICATION_SCOPE;
        }

        return scope;
    }
    
    
}

