/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/jstl/org/apache/slide/taglib/tag/jstl/NodeTag.java,v 1.3 2004/07/30 06:51:49 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:49 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. the names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.tag.jstl;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

import org.apache.slide.common.SlideException;
import org.apache.slide.taglib.bean.NamespaceBean;
import org.apache.slide.taglib.bean.NodeBean;
import org.apache.slide.taglib.tag.NodeTagSupport;


/**
 * Tag class for tags that represent a particular node in a Slide namespace.
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class NodeTag
    extends NodeTagSupport {
    
    
    // ------------------------------------------------------------ Tag Methods
    
    
    /**
     * Called by the JSP Engine when opening this tag.
     *
     * @throws JspException not thrown
     */
    public int doStartTag()
        throws JspException {
        
        // evaluate the 'uri' attribute
        String evalUri = (String)
            JstlTagUtils.evaluateRequiredAttribute("node", "uri", uri,
                                                   String.class, this,
                                                   pageContext);
        
        // evaluate the 'resolveLinks' attribute
        Boolean evalResolveLinks = (Boolean)
            JstlTagUtils.evaluateOptionalAttribute("node", "resolveLinks",
                                                   resolveLinks, Boolean.class,
                                                   this, pageContext);
        
        // we trust the 'uri' attribute to be != null, because it is specified
        // as required attribute in the TLD
        NamespaceBean namespace = 
            JstlTagUtils.findNamespace(this, pageContext);
        node = getNode(namespace, evalUri, evalResolveLinks != null ? 
                                           evalResolveLinks.booleanValue() : 
                                           true);
        
        return super.doStartTag();
    }
    
    
    // --------------------------------------------------------- Public Methods
    
    
    /**
     * Set the 'var' attribute.
     *
     * @param var the attribute value
     */
    public void setVar(String var) {
        
        attrName = var;
    }
    
    
}

