/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/struts/org/apache/slide/taglib/tag/struts/IterateMembersTag.java,v 1.3 2004/07/30 06:51:51 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:51 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.tag.struts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

import javax.servlet.jsp.JspException;

import org.apache.slide.taglib.bean.NodeBean;
import org.apache.slide.taglib.util.Iterators;
import org.apache.struts.taglib.logic.IterateTag;

/**
 * Tag class that extends the generic Struts iteration tag to provide iteration
 * over the members of a specific node up to a configurable depth, including 
 * and/or excluding specific types and/or roles of objects.
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class IterateMembersTag
    extends IterateTag {
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * Value of the 'depth' attribute.
     */
    protected String depth;
    
    
    /**
     * Value of the 'includeRoles' attribute.
     */
    protected String includeRoles;
    
    
    /**
     * Value of the 'excludeRoles' attribute.
     */
    protected String excludeRoles;
    
    
    /**
     * Value of the 'includeTypes' attribute.
     */
    protected String includeTypes;
    
    
    /**
     * Value of the 'excludeTypes' attribute.
     */
    protected String excludeTypes;
    
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Default constructor.
     */
    public IterateMembersTag() {
        
        init();
    }
    
    
    // ------------------------------------------------------------ Tag Methods
    
    
    /**
     * Called by the JSP Engine when opening this tag.
     *
     * @throws JspException not thrown
     */
    public int doStartTag()
        throws JspException {
        
        NodeBean node = StrutsTagUtils.findNode(this, pageContext);
        if (node == null) {
            throw new JspException("The 'iterateMembers' tag must be nested " +
                "inside a 'node' tag or an iteration over nodes.");
        }
        
        int depthValue = 1;
        if (depth != null) {
            try {
                depthValue = Integer.parseInt(depth);
            } catch (NumberFormatException e) {
                if (depth.equalsIgnoreCase("infinity")) {
                    depthValue = Integer.MAX_VALUE;
                }
                else {
                    throw new JspException("The attribute 'depth' of the " +
                        "'iterateMembers' tag must contain an integer value.");
                }
            }
        }
        
        setCollection(Iterators.membersIterator(node, depthValue,
                                                tokenizeString(excludeRoles),
                                                tokenizeString(includeRoles),
                                                tokenizeString(excludeTypes),
                                                tokenizeString(includeTypes)));
        
        return super.doStartTag();
    }
    
    
    /**
     * Called by the JSP Engine when closing this tag.
     *
     * @throws JspException not thrown
     */
    public int doEndTag()
        throws JspException {
        
        init();
        
        return super.doEndTag();
    }
    
    
    /**
     * Releases any resources we may have (or inherit).
     */
    public void release() {
        super.release();
        
        init();
    }
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Sets the 'depth' attribute.
     *
     * @param depth the attribute value
     */
    public void setDepth(String depth) {
        
        this.depth = depth;
    }
    
    
    /**
     * Sets the 'excludeTypes' attribute.
     *
     * @param excludeTypes the attribute value
     */
    public void setExcludeTypes(String excludeTypes) {
        
        this.excludeTypes = excludeTypes;
    }
    
    
    /**
     * Sets the 'includeTypes' attribute.
     *
     * @param includeTypes the attribute value
     */
    public void setIncludeTypes(String includeTypes) {
        
        this.includeTypes = includeTypes;
    }
    
    
    /**
     * Sets the 'excludeRoles' attribute.
     *
     * @param excludeRoles the attribute value
     */
    public void setExcludeRoles(String excludeRoles) {
        
        this.excludeRoles = excludeRoles;
    }
    
    
    /**
     * Sets the 'includeRoles' attribute.
     *
     * @param includeRoles the attribute value
     */
    public void setIncludeRoles(String includeRoles) {
        
        this.includeRoles = includeRoles;
    }
    
    
    // -------------------------------------------------------- Private Methods
    
    
    /**
     * Initialize state for tag reuse.
     */
    private void init() {
        
        depth = null;
        includeRoles = null;
        excludeRoles = null;
        includeTypes = null;
        excludeTypes = null;
        iterator = null;
    }
    
    
    /**
     * Splits the given string into its tokens, separated by commata, and 
     * returns the tokens in a immutable Set.
     */
    private static Set tokenizeString(String values) {
        
        Set set = new HashSet();
        if (values != null) {
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                set.add(((String)st.nextElement()).trim());
            }
        }
        
        return Collections.unmodifiableSet(set);
    }
    
    
}

