/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/taglib/src/struts/org/apache/slide/taglib/tag/struts/StrutsTagUtils.java,v 1.3 2004/07/30 06:51:51 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:51 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 

package org.apache.slide.taglib.tag.struts;

import java.security.Principal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.taglib.bean.*;
import org.apache.slide.taglib.tag.*;
import org.apache.struts.taglib.logic.IterateTag;

/**
 * Contains static methods to locate beans in the JSP page context that 
 * represent certain Slide objects. These methods closely cooperate with the
 * Struts tag library, especially the <code>&lt;logic:iterate&gt;</code> tag.
 * 
 * @author <a href="mailto:cmlenz@apache.org">Christopher Lenz</a>
 * @version $Revision: 1.3 $
 */
public class StrutsTagUtils {
    
    
    // -------------------------------------------------- Public Static Methods
    
    
    /**
     * Locate the closest DomainBean up the tag hierarchy, or create one if 
     * none was found.
     */
    public static DomainBean findDomain(Tag from, PageContext context)
        throws JspException {
        
        DomainBean bean = null;
        
        // look for the closest NamespaceTagSupport or IterateTag up the tag 
        // hierarchy
        Tag tag = from.getParent();
        while (tag != null) {
            if (tag instanceof DomainTagSupport) {
                return ((DomainTagSupport)tag).getDomain();
            }
            tag = tag.getParent();
        }
        
        // create a new domain bean
        HttpServletRequest request =
            (HttpServletRequest)context.getRequest();
        Principal principal = request.getUserPrincipal();
        CredentialsToken credentials;
        if (principal == null) {
            credentials = new CredentialsToken("");
        } else {
            credentials = new CredentialsToken(principal);
        }
        SlideToken st = new SlideTokenImpl(credentials);
        return new DomainBean(st);
    }
    
    
    /**
     * Locate the closest NamespaceBean up the tag hierarchy, or use the 
     * default namespace if none was found.
     */
    public static NamespaceBean findNamespace(Tag from, PageContext context)
        throws JspException {
        
        NamespaceBean bean = null;
        
        // look for the closest NamespaceTagSupport or IterateTag up the tag 
        // hierarchy
        Tag tag = from.getParent();
        while (tag != null) {
            if (tag instanceof NamespaceTagSupport) {
                bean = ((NamespaceTagSupport)tag).getNamespace();
            } else if (tag instanceof IterateTag) {
                // check whether we're actually iterating over NamespaceBean
                // objects
                String id = ((IterateTag)tag).getId();
                if ((id != null) && (id.length() > 0)) {
                    Object object = context.getAttribute(id);
                    if (object instanceof NamespaceBean) {
                        bean = (NamespaceBean)object;
                    }
                }
            }
            if (bean != null) {
                return bean;
            }
            tag = tag.getParent();
        }
        
        // not nested in a namespace tag, so return either:
        // - the namespace specified as context parameter or
        // - the default namespace
        DomainBean domain = findDomain(from, context);
        if (domain != null) {
            String namespaceName = 
                (String) context.getServletContext().getAttribute
                ("org.apache.slide.NamespaceName");
            if (namespaceName == null) {
                namespaceName =
                    context.getServletContext().getInitParameter
                    ("org.apache.slide.NamespaceName");
            }
            if (namespaceName != null) {
                bean = domain.getNamespace(namespaceName);
            } else {
                bean = domain.getDefaultNamespace();
            }
        }
        
        return bean;
    }
    
    
    /**
     * Locate the closest NodeBean up the tag hierarchy. If no NodeBean can be
     * found, return <code>null</code>.
     */
    public static NodeBean findNode(Tag from, PageContext context)
        throws JspException {
        
        NodeBean bean = null;
        
        // look for the closest NodeTagSupport or IterateTag up the tag 
        // hierarchy
        Tag tag = from.getParent();
        while (tag != null) {
            if (tag instanceof NodeTagSupport) {
                bean = ((NodeTagSupport)tag).getNode();
            } else if (tag instanceof IterateTag) {
                // check whether we're actually iterating over NamespaceBean
                // objects
                String id = ((IterateTag)tag).getId();
                if ((id != null) && (id.length() > 0)) {
                    Object object = context.getAttribute(id);
                    if (object instanceof NodeBean) {
                        bean = (NodeBean)object;
                    }
                }
            }
            if (bean != null) {
                return bean;
            }
            tag = tag.getParent();
        }
        
        return bean;
    }
    
    
    /**
     * Locate the closest RevisionBean up the tag hierarchy. If no RevisionBean
     * can be found, return <code>null</code>.
     */
    public static RevisionBean findRevision(Tag from, PageContext context)
        throws JspException {
        
        RevisionBean bean = null;
        
        // look for the closest RevisionTagSupport or IterateTag up the tag 
        // hierarchy
        Tag tag = from.getParent();
        while (tag != null) {
            if (tag instanceof RevisionTagSupport) {
                bean = ((RevisionTagSupport)tag).getRevision();
            } else if (tag instanceof NodeTagSupport) {
                bean = ((NodeTagSupport)tag).getNode().getLatestRevision();
            } else if (tag instanceof IterateTag) {
                // check whether we're actually iterating over RevisionBean
                // or NodeBean objects
                String id = ((IterateTag)tag).getId();
                if ((id != null) && (id.length() > 0)) {
                    Object object = context.getAttribute(id);
                    if (object instanceof RevisionBean) {
                        bean = (RevisionBean)object;
                    } else if (object instanceof NodeBean) {
                        bean = ((NodeBean)object).getLatestRevision();
                    }
                }
            }
            if (bean != null) {
                return bean;
            }
            tag = tag.getParent();
        }
        
        return bean;
    }
    
    
}

