/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/common/IDesc.java,v 1.3 2004/07/30 06:51:52 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:52 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.common;



/**
 * Base interface for the common aspects of the store's and the
 * database's view to a Descriptors object.
 * An IDescriptors object (= descriptors object) contains all
 * metadata aspects for one resource and, additionally, contains
 * the addresses of the associated content objects within database.
 * Moreover, a descriptors object has a state flag, specifying
 * whether the object is created, changed or deleted. A
 * descriptors object is uniquely identified by a URI.
 * IDescriptors exports an interface to get, set and remove all
 * contained metadata aspects. When a resource is created, an
 * empty IDescriptors object is instantiated and is accessible via
 * current Thread object and URI within the delta (XDelta). Now,
 * the non-content stores can access it via set, get and remove
 * methods. At commit, descriptors objects are sent to the database
 * and moved from XDelta to the global cache, XCache. An IDescriptors
 * object is automatically marked deleted, when all its metadata
 * aspects have been removed.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public interface IDesc {

    /** indicates IDescriptors object is stateless (just instanciated) */
    public static final int NO_STATE = 0;

    /** indicates IDescriptors object is CREATED (needs to be stored) */
    public static final int CREATED = 1;

    /** indicates IDescriptors object is CREATED and DELETED (ignore when flushed) */
    public static final int CREATED_DELETED = 2;

    /** indicates IDescriptors object is DELETED (delete from store) */
    public static final int DELETED = 3;

    /** indicates IDescriptors object is UNCHANGED (ignore when flushed) */
    public static final int UNCHANGED = 4;

    /** indicates IDescriptors object is CHANGED (update when flushed) */
    public static final int CHANGED = 5;


    /**
     * retrieves the uri of this resource.
     *
     * @return   the uri of this resource
     */
    public String getUuri ();

    /**
     * retrieves the current state of this Descriptors object
     *
     * @return     the current state of this Descriptors object
     */
    public int getState ();

    /**
     * call this to tell this IDescriptors object that it has been successfully
     * committed.
     */
    public void commitEvent ();


//  /**
//   * sets the current state
//   *
//   * @param     the current state of this Descriptors object
//   */
//   public void setState (int state);

}

