/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/common/IDescriptors.java,v 1.3 2004/07/30 06:51:52 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:52 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.common;

import java.util.Enumeration;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.structure.ObjectNode;


/**
 * Describes the XDescriptorsStore's view to a Descriptors object.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 * @see IDesc
 */
public interface IDescriptors extends IDesc {


    /**
     * sets the structure aspect of this resource.
     *
     * @pre        object != null
     * @post
     *
     * @param      object   the structure aspect of this resource
     */
    public void setObjectNode (ObjectNode object);

    public ObjectNode getUuriObjectNode ();

    /**
     * retrieves the structure aspect of this resource.
     *
     * @pre        object != null
     * @post
     *
     * @return     the structure aspect of this resource
     */
    public ObjectNode getObjectNode (String uri);

    /**
     * removes the structure aspect of this resource.
     *
     * @pre        object != null
     * @post
     *
     * @return     true if objectNode could be removed
     */
    public boolean  removeObjectNode ();

    /**
     * sets the revisions aspect of this resource.
     *
     * @pre        object != null
     * @post
     *
     * @param      revisionDescriptors   the revisions aspect of this resource
     */
    public void setRevisionDescriptors (NodeRevisionDescriptors revisionDescriptors);

    public NodeRevisionDescriptors getUuriRevisionDescriptors ();

    /**
     * retrieves the revisions aspect of this resource.
     *
     * @pre        object != null
     * @post
     *
     * @return     the revisions aspect of this resource
     */
    public NodeRevisionDescriptors getRevisionDescriptors (String uri);

    /**
     * removes the revisions aspect of this resource.
     *
     * @pre        object != null
     * @post
     *
     * @param      revisionDescriptors   the revisions aspect of this resource
     *
     * @return     false if already deleted
     */
    public boolean  removeRevisionDescriptors (NodeRevisionDescriptors revisionDescriptors);

    /**
     * sets a specific revision aspect within this resource.
     *
     * @pre        object != null
     * @post
     *
     * @param      revisionDescriptor   the revision aspect of this resource
     */
    public void setRevisionDescriptor (NodeRevisionDescriptor revisionDescriptor);

    /**
     * retrieves a specific revision aspect within this resource.
     *
     * @pre        revisionNumber != null
     * @post
     *
     * @param      revisionNumber identifies a specific revision within
     *             current resource
     *
     * @return     the revision identified by revisionNumber
     */
    public NodeRevisionDescriptor getRevisionDescriptor
        (NodeRevisionNumber revisionNumber);

    /**
     * Get enumeration of all descriptor aspects
     *
     * @return      Enumeration containing all descriptor aspects
     */
    public Enumeration getRevisionDescriptorList ();

    /**
     * removes a specific revision within this resource.
     *
     * @pre        revisionDescriptor != null
     * @post
     *
     * @param      revisionDescriptor   the revision aspect to be removed
     *
     * @return     true if the revisionDescriptor was found and removed
     */
    public boolean removeRevisionDescriptor
        (NodeRevisionDescriptor revisionDescriptor);

    /**
     * sets a lock for this resource
     *
     * @pre        lock != null
     * @post
     *
     * @param      lock   the lock to be set
     */
    public void  setNodeLock (NodeLock lock);

    /**
     * removes a lock for this resource
     *
     * @pre        lock != null
     * @post
     *
     * @param  lock the lock to be removed
     *
     * @return true if the lock was found and removed
     */
    public boolean removeLock (NodeLock lock);

    /**
     * get all locks for this resource
     *
     * @return      Enumeration containing all locks
     */
    public Enumeration getLocks (String uri);

    /**
     * sets the readOnly flag of this resource
     *
     * @param   readOnly   true or false
     */
    public void  setReadOnly (boolean readOnly);

    /**
     * retrieves the readOnly flag of this resource
     *
     * @return      true if this resource is readOnly else false
     */
    public boolean  isReadOnly ();

    /**
     * Returns true if the state of this resource is deleted
     *
     * @return      true   if this resource's state is either DELETED or
     *                     CREATED_DELETED
     */
    public boolean  isDeleted();

    /**
     * Creates a deep clone of this IDescriptors object
     *
     * @return     a deep copy of this IDescriptors object
     */
    public IDescriptors getClone(String uuri);
}


