/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/common/IDescriptorsDocument.java,v 1.3 2004/07/30 06:51:52 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:52 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.common;

import org.jdom.Document;


/**
 * Describes the database's view to a Descriptors object.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 * @see IDesc
 */
public interface IDescriptorsDocument extends IDesc {

    /**
     * retrieves the jdom document representing this Descriptors object
     *
     * @return     the jdom document representing this Descriptors object
     */
    public Document toXml ();

    /**
     * retrieves the descriptorsId. The descriptorsId is a string representing
     * physical location of this object within database (schema and ino:id).
     * If a Descriptors object is in cache and must accessed in datastore (update
     * or delete), access can be faster.
     *
     * @return     a string representing physical location
     */
    public String getDescriptorsId ();

    /**
     * sets the descriptorsId.
     *
     * @param  descriptorsId   the current state of this Descriptors object
     */
    public void setDescriptorsId (String descriptorsId);


    /**
     * checks the validy of this document.
     *
     */
    public void validate ();

}

