/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/common/XConflictException.java,v 1.3 2004/07/30 06:51:52 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:52 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.common;

import org.apache.slide.util.XException;


/**
 ** This exception signals a conflict which can arise in one of the XDAV stores.
 ** Example: a thread cannot obtain a descriptors object for write since it is t-locked
 ** by another thread.
 **
 ** @author    peter.nevermann@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XConflictException extends  XException {
    
    /**
     * Default constructor.
     */
    public XConflictException() {
    }
    
    /**
     * Constructor using a message.
     * @param msg  the message
     */
    public XConflictException(String msg) {
        super(msg);
    }
    
    /**
     * Constructor with a nested exception.
     * @param e  the nested exception
     */
    public XConflictException (Exception e) {
        super(e);
    }
    
    /**
     * Constructor with a nested exception an a message.
     * @param msg  the message
     * @param e  the nested exception
     */
    public XConflictException (String msg, Exception e) {
        super(msg, e);
    }
}

