/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/common/XGlobals.java,v 1.3 2004/07/30 06:51:53 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:53 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.common;

import java.text.SimpleDateFormat;
import org.apache.slide.util.XUri;

/**
 ** Some global constants of xdav.
 **
 ** @author    Hardy.Kiefer@softwareag.com
 **
 ** @version   $Revision: 1.3 $
 **/
public interface XGlobals {
    /** General */
    String TSD_SUFF                         = ".tsd";
    String XSD_SUFF                         = ".xsd";
    
    String USE_BINDING                      = "useBinding";
    
    /** Tamino connection */
    String TAMINO_USER                      = "user";
    String TAMINO_PASSWD                    = "password";
    String TAMINO_DOMAIN                    = "domain";
    String TAMINO_BASE                      = "taminoBase";
    String TAMINO_DATABASE                  = "database";
    String TAMINO_COLLECTION                = "collection";
    String TAMINO_DOCTYPE                   = "doctype";
    String TAMINO_NAME                      = "name";
    String TAMINO_ANNOTATION                = "annotation";
    String TAMINO_APPINFO                   = "appinfo";
    String TAMINO_SCHEMA_INFO               = "schemaInfo";
    String TAMINO_ADMIN_INFO                = "adminInfo";
    String TAMINO_VERSION                   = "version";
    String TRY_CONNECT                      = "tryConnect";
    String TRY_CONNECT_DELAY                = "tryConnectDelay";
    String POOL_MAX_CONNECTIONS             = "maxConnections";
    String POOL_INIT_CONNECTIONS            = "initConnections";
    String POOL_CONNECTION_TIMEOUT          = "connectionTimeout";
    String USER_ID                          = "user";
    String PASSWORD                         = "password";
    String INO_COLLECTION                   = "ino:collection";
    String TARGET_NAMESPACE                 = "targetNamespace";
    String SCHEMA                           = "schema";
    
    /** Tamino schema version */
    String TSD2_SCHEMA_VERSION              = "TSD2";
    String TSD3_SCHEMA_VERSION              = "TSD3";
    String TSD4_SCHEMA_VERSION              = "TSD4";
    
    /** constant: metadata schema version*/
    String SCHEMA_VERSION                   = "1.1";
    String SCHEMA_VERSION_1_0               = "1.0"; // StarOffice release.
    String SCHEMA_VERSION_0_4               = "0.4";
    String SCHEMA_VERSION_0_3               = "0.3";
    String SCHEMA_VERSION_0_2               = "0.2";
    String SCHEMA_VERSION_0_1               = "0.1";
    
    
    /** XDAV default Tamino colls */
    String META_COLLECTION                  = "xdav:metadata";
    
    /** XDAV default Tamino doctypes */
    String NONXML_CONTENT                   = "xdav_nonXML";
    
    
    
    public static final String NIXE_META         = "nixe-meta";
    public static final String NIXE_CONTENT      = "nixe-content";
    
    
    /** XDAV XML namespace */
    String DUMMY_NAMESPACE_PREFIX           = "defaultPrefix";
    String DUMMY_NAMESPACE_URI              = "http://namespaces.softwareag.com/tamino/webdav/noValidNamespaceGiven";
    String TAMINO_NAMESPACE_URI             = "http://namespaces.softwareag.com/tamino/webdav";
    String TAMINO_NAMESPACE_PREFIX          = "xsv";
    
    String TAMINO_TSD_2_NAMESPACE_URI             = "http://namespaces.softwareag.com/tamino/response2";
    String TAMINO_TSD_2_NAMESPACE_PREFIX          = "ino";
    
    String TAMINO_TSD_3_NAMESPACE_URI             = "http://namespaces.softwareag.com/tamino/TaminoSchemaDefinition";
    String TAMINO_TSD_3_NAMESPACE_PREFIX          = "tsd";
    
    String XML_SCHEMA_NAMESPACE_URI               = "http://www.w3.org/2001/XMLSchema";
    String XML_SCHEMA_NAMESPACE_PREFIX          = "xs";
    
    String XQL_NAMESPACE_URI                = "http://metalab.unc.edu/xql/";
    String XQL_NAMESPACE_PREFIX             = "xql";
    
    /** WebDAV server urls */
    String URL_SCHEMA_ELEMENT_NAME          = "webdavserverurls";
    String URL_SCHEMA_NAME                  = TAMINO_NAMESPACE_PREFIX+":"+URL_SCHEMA_ELEMENT_NAME;
    
    /** Globals */
    String GLOBALS_SCHEMA_ELEMENT_NAME      = "globals";
    String GLOBALS_SCHEMA_NAME              = TAMINO_NAMESPACE_PREFIX+":"+GLOBALS_SCHEMA_ELEMENT_NAME;
    
    /** XDAV miscellaneous */
    String IS_XML                           = "isXml";
    String DEPTH                            = "depth";
    String CONTENT_LENGTH                   = "content-length";
    String WEBAPPS                          = "webapps";
    String WEB_INF                          = "WEB-INF";
    String WEB_XML                          = "web.xml";
    String DOMAIN                           = "Domain";                   // the default domain file name without suffix
    String DOMAIN_XML                       = DOMAIN + XUri.XML_SUFF;            // the default domain file name
    String CC_MAX_ESIZE                     = "contentCacheMaxEntrySize"; // max.size forcontent cache entries
    long CC_MAX_ESIZE_DEFAULT               = 4096;                       // default for CC_MAX_ESIZE (4K)
    
    String DEFAULT_QUERY = org.apache.slide.store.tamino.datastore.search.XBasicQueryImpl.class.getName();
    
    String DELTAV_GLOBAL_PARMS_FILENAME     = "deltav";
    String DELTAV_GLOBAL_PARMS_COLNAME      = "globals";
    String EMPTY_CONTENT_ID                 = "*empty*";
    
    /** XDAV live props */
    String CONTENT_ID                       = "xdavContentId";
    String LAST_MODIFIED_DATE               = "getlastmodified";
    
    /** XDAV Repairer */
    int ON_OPEN_TA_WAIT                     = 0;
    int ON_OPEN_TA_ERROR                    = 1;
    int ON_OPEN_TA_ROLLBACK                 = 2;
    long ON_OPEN_TA_WAIT_TIMEOUT            = 60000;    //default: 1 min
    boolean CLEAR_REPAIR_MODE_TOKEN_ON_INIT = true;
    
    /** XDAV admin scope. TODO: dump this constant, use XStore.getScope */
    String REPAIRER_URI                     = XUri.SEP+"administration"+XUri.SEP+"repairer";
    
    String REPAIRER_DIR_NAME                = "repairer";
    
    /** Slide misc */
    String TEMPACTION_URI                   = XUri.SEP+"tempaction";
    
    /** Query */
    int    MAX_SHADOW_SIZE                  = 333;
    int    MAX_TEXT_SEARCH_SIZE             = 62;
    String TMP_RESULT_WRAPPER               = "tmpResultWrapper";
    
    
    String PORT_SELECTION_NAME              = "port";
    String HOST_SELECTION_NAME              = "host";
    String FORCE_CONNECT_SELECTION_NAME     = "force-connection";
    
    SimpleDateFormat XS_DATE_FORMATTER = new SimpleDateFormat ("yyyy-MM-dd'T'HH:mm:ss");
    
}

