/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/common/XTLockSettings.java,v 1.2 2005/02/25 15:58:38 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2005/02/25 15:58:38 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.common;


/**
 ** Holds t-lock customization settings like timeout, isolation-level.
 **
 ** @author    peter.nevermann@softwareag.com
 ** @version   $Revision: 1.2 $
 **/
public class XTLockSettings {
    
    public static int
        READ_COMMITTED = 0,
        SERIALIZABLE   = 1;
    
    public static String
        S_READ_COMMITTED = "READ COMMITTED",
        S_SERIALIZABLE   = "SERIALIZABLE";
    
    private long timeout;
    private int isolationLevel;
    
    /**
     * Constructor
     *
     * @param    timeout             a  long
     */
    public XTLockSettings(long timeout) {
        this(timeout, SERIALIZABLE);
    }
        
    /**
     * Constructor
     *
     * @param    timeout             a  long
     * @param    isolationLevel      an int
     */
    public XTLockSettings(long timeout, int isolationLevel) {
        this.timeout = timeout;
        this.isolationLevel = isolationLevel;
    }
    
    /**
     * Sets timeout
     *
     * @param    timeout             a  long
     */
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
    
    /**
     * Returns timeout
     *
     * @return    a  long
     */
    public long getTimeout() {
        return timeout;
    }
    
    /**
     * Sets isolationLevel
     *
     * @param    isolationLevel      an int
     */
    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }
    
    /**
     * Returns isolationLevel
     *
     * @return    an int
     */
    public int getIsolationLevel() {
        return isolationLevel;
    }
    
    public String toString() {
        return "[timeout="+timeout+", isolation-level="+(isolationLevel == READ_COMMITTED ? S_READ_COMMITTED : S_SERIALIZABLE)+"]";
    }
}

