/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/common/XUriCache.java,v 1.1 2004/03/25 16:17:59 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:17:59 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.slide.store.tamino.jdomobjects.XUuri;
import org.apache.slide.util.XAssertionFailed;

/**
 * Maps Uris to Uuris. Needed to find newly created descriptors that have not been added to the
 * structure. Should become obsolte with slide uses resourceIds.
 *
 * @version   $Revision: 1.1 $
 */
public class XUriCache {
    /** maps uris to uuri **/
    private final Map map;

    /**
     * Default constructor.
     */
    public XUriCache() {
        this.map = new HashMap();
    }

    public void put(String uri, String uuri) {
        if (uri == null) {
            throw new XAssertionFailed();
        }
        if (uuri == null) {
            throw new XAssertionFailed();
        }
            
        if (map.put(uri, uuri) != null) {
            throw new XAssertionFailed();
        }
    }

    public String get(String uri) {
        return (String) map.get(uri);
    }
    
    public String getOrCreate(boolean useBinding, String uri) {
        String uuri;
        
        uuri = get(uri);
        if (uuri == null) {
            uuri = XUuri.create(useBinding, uri);
            put(uri, uuri);
        }
        return uuri;
    }

    public void removeValue(String uuri) {
        Collection values;

        values = map.values();
        if (!values.remove(uuri)) {
            throw new XAssertionFailed(uuri);
        }
    }
}
