/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/ContentCollection.java,v 1.3 2004/07/30 06:51:54 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:54 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.datastore;

/**
 * ContentCollection.java
 *
 * @author Created by Omnicore CodeGuide
 */
public class ContentCollection implements IContentCollection {
    
    
    private String collection;
    private String uri;
    private String schemaLanguage;
    
    
    /**
     *
     */
    public ContentCollection (String taminoBase,  String database, String collection) {
        this.collection = collection;
        this.uri = taminoBase + "/" + database + "/" + collection;
    }
    
    /**
     *
     */
    public ContentCollection (String taminoBase,  String database, String collection, String schemaLanguage) {
        this (taminoBase, database, collection);
        this.schemaLanguage = schemaLanguage;
    }

    /**
     * Method getCollectionName
     *
     * @return   a String
     *
     */
    public String getCollectionName() {
        return collection;
    }
    
    /**
     * Method getFullQualifiedName
     *
     * @return   a String
     *
     */
    public String getUri() {
        return uri;
    }
    
    
    /**
     * Method getSchemaVersion
     *
     * @return   a String
     *
     */
    public String getSchemaVersion ()  {
        return schemaLanguage;
    }
}


