/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/TaminoCodes.java,v 1.2 2005/02/25 15:58:37 pnever Exp $
 * $Revision: 1.2 $
 * $Date: 2005/02/25 15:58:37 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore;

import java.util.*;

import java.text.DecimalFormat;
import org.apache.slide.common.Domain;


/**
 ** Helper class for handling Tamino codes.
 ** NOTE: Assuming 4-character codes !!!!
 **
 ** @author    peter.nevermann@softwareag.com
 ** @version   $Revision: 1.2 $
 **/

public class TaminoCodes {
    
    private static Set nonabortingCodes = null;
    private static DecimalFormat df = new DecimalFormat("0000");
    private static boolean allCodesAreNonAborting = false;
    
    public static boolean isNonaborting(String code) {
        if (nonabortingCodes == null) {
            loadCodes();
            System.out.println("@@@ Tamino codes non-aborting: "+(allCodesAreNonAborting
                                                                      ? "*** DISABLED ***"
                                                                      : String.valueOf(nonabortingCodes)));
        }
        if (allCodesAreNonAborting) {
            return true;
        }
        else {
            return nonabortingCodes.contains(code);
        }
    }
    
    private static void loadCodes() {
        String codes = Domain.getParameter("taminocodes-nonaborting");
        if (codes == null) {
            allCodesAreNonAborting = true;
            nonabortingCodes = Collections.EMPTY_SET;
        }
        else {
            nonabortingCodes = loadCodes(codes);
        }
    }
    
    private static Set loadCodes(String codes) {
        Set result = new TreeSet();
        StringTokenizer st = new StringTokenizer(codes, ", ");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.indexOf('-') >= 0) {
                result.addAll(getCodesInRange(t));
            }
            else {
                result.add(t);
            }
        }
        return result;
    }
    
    private static List getCodesInRange(String range) {
        List result = new ArrayList();
        int idx = range.indexOf('-');
        int from = (idx == 0 ? 0 : Integer.parseInt(range.substring(0,idx)));
        int to = (idx == range.length() - 1 ? 9999 : Integer.parseInt(range.substring(idx + 1)));
        if (from > to) {
            System.out.println("@@@ WARNING: invalid range of Tamino codes specified: "+range);
        }
        for (int i = from; i <= to; i++) {
            //String c = df.format((long)i);
            String c = String.valueOf(i);
            result.add(c);
        }
        return result;
    }
}

