/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/TaminoParameters.java,v 1.4 2004/09/15 14:58:25 pnever Exp $
 * $Revision: 1.4 $
 * $Date: 2004/09/15 14:58:25 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.slide.common.Namespace;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.store.ISlideAccessor;
import org.apache.slide.store.tamino.store.monitoring.IMonitor;
import org.apache.slide.store.tamino.store.monitoring.IMonitorable;
import org.apache.slide.store.tamino.store.monitoring.Monitor;

/**
 ** Helper class; Allows to instantiate an XDbHandler outside the context of Slide.
 ** Used for testing and tools.
 **
 ** @author    martin.wallmer@softwareag.com
 ** @version   $Revision: 1.4 $
 **/
public class TaminoParameters implements ISlideAccessor, IMonitorable, XGlobals {
    private static int numberOfInstances = 0;

    private final String namespaceName;
    private final Properties prop = new Properties();

    private final IMonitor monitor;
    private final String monName;
    private final String monParent = null;
    private final List monChildren = new ArrayList();
    
    
    /**
     ** Constructor of TaminoParameters.
     **
     ** @param      taminoBase         taminoBase
     ** @param      taminoDatabase     taminoDatabase
     ** @param      taminoCollection   taminoCollection
     **/
    public TaminoParameters(String namespaceName, String taminoBase, String taminoDatabase, String taminoCollection) {
        this.namespaceName = namespaceName;
        prop.setProperty (TAMINO_BASE, taminoBase);
        prop.setProperty (TAMINO_DATABASE, taminoDatabase);
        prop.setProperty (TAMINO_COLLECTION, taminoCollection);
        prop.setProperty ("dbSessionClass", XDbSession.class.getName());
        
        monName = new StringBuffer ("fakeStore_").append (numberOfInstances++).toString();
        monitor = Monitor.getMonitor (this);
    }
    
    public String getNamespaceName() {
        return namespaceName;
    }
    
    public Namespace getNamespace() {
        return null;
    }
    
    /**
     * Get the parameter.
     * @param name name of the parameter
     * @return  parameter
     */
    public String getParameter( String name ) {
        String par = null;
        String property = prop.getProperty(name);
        if (property != null)
            par = property;
        
        return par;
    }
    
    /**
     * Set the parameter.
     * @param key key of the parameter
     * @param value value of the parameter
     */
    public void setParameter (String key, String value) {
        prop.setProperty(key, value);
    }
    
    
    /**
     * Get the Monitor name (fake IMonitorable).
     * @return the monitor name
     */
    public String getMonName () {
        return monName;
    }
    
    /**
     * Get this Monitor parent.
     * @return null (no parent)
     */
    public IMonitorable getMonParent() {
        return null;
    }
    
    
    /**
     * Get this Monitor children.
     * @return monitor children
     */
    public List getMonChildren() {
        return monChildren;
    }
    
    /**
     * Get the Monitor.
     * @return the monitor
     */
    public IMonitor getMonitor() {
        return monitor;
    }
    
    /**
     * Get a Monitor property.
     * @param prop property name
     * @return null
     */
    public Object getMonProperty( String prop ) {
        return null;
    }
    
}




