/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/XPathFactory.java,v 1.1 2004/03/25 16:18:00 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:00 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore;

import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.XPathExpression;

public class XPathFactory {

    public static XPathExpression uuris(String collection) {
        // note: for historical reasons, descriptors store the uuri in an uri attribute
        return create("? /@uri", collection);
    }

    public static XPathExpression descByInoId(String collection, String inoId) {
        // note: for historical reasons, descriptors store the uuri in an uri attribute
        return create("?[@ino:id=\"?\"]", collection, inoId);
    }

    public static XPathExpression descByUuri(String collection, String uuri) {
        return create("? [@uri=\"?\"]", collection, XPathExpression.mask(uuri));
    }

    public static XPathExpression webdavUrls(String collection) {
        return create (XGlobals.URL_SCHEMA_NAME + "[taminoCollection=\"?\"]", collection);
    }

    public static XPathExpression contentIds(String collection) {
        return create("?/descriptorList/descriptor/propertyList/xsv:xdavContentId/shadow", collection);
    }

    public static XPathExpression mapType(String collection, String schema) {
        return create("ino:collection [@ino:name=\"?\"]/ino:doctype[@ino:name=\"?\"]/ino:node[@ino:name=\"?\"]/@ino:map-type",
                      collection, schema, schema);
    }

    public static XPathExpression mapTypeTSD3(String collection, String schema) {
        return create("/xs:schema/xs:annotation/xs:appinfo/tsd:schemaInfo/tsd:doctype[../tsd:collection/@name=\"?\" and @name=\"?\"]",
                      collection, schema);
    }

    public static XPathExpression globalsConfig(String collection) {
        return create(XGlobals.GLOBALS_SCHEMA_NAME+"[taminoCollection=\"?\"]/configuration", collection);
    }


    private static XPathExpression create(String xpath, String parm1) {
        return create(xpath, new String[] { parm1 });
    }
    private static XPathExpression create(String xpath, String parm1, String parm2) {
        return create(xpath, new String[] { parm1, parm2 });
    }
    private static XPathExpression create(String xpath, String parm1, String parm2, String parm3) {
        return create(xpath, new String[] { parm1, parm2, parm3 });
    }
    private static XPathExpression create(String xpath, String[] parms) {
        XPathExpression e;
        int i;

        e = new XPathExpression(xpath);
        for (i = 0; i < parms.length; i++) {
            e.setParameter(i, parms[i]);
        }
        return e;
    }
}

