/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/XProcessResultParser.java,v 1.4 2004/12/15 10:38:27 pnever Exp $
 * $Revision: 1.4 $
 * $Date: 2004/12/15 10:38:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.datastore;

import com.softwareag.tamino.db.api.io.TInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.slide.store.tamino.jdomobjects.SAXParserPool;
import org.apache.slide.util.XException;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * Used to parse the response from Tamino when objects where processed via
 * TStreamAccessor.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.4 $
 */
public class XProcessResultParser
{
    
    /** list of all ino:ids returned by Tamino */
    private List inoIds;
    
    /** last response */
    private String lastResponse;
    
    /** last message */
    private String lastMessage;
    
    /**
     * parses the input stream
     *
     * @param    in                  a  TInputStream
     *
     * @throws   XException
     *
     */
    public void parse (TInputStream in) throws XException {
        try
        {
            SAXParser parser = SAXParserPool.getParser (new NameSpaceContentHandler());
            parser.parse (new InputSource (in));
            SAXParserPool.returnParser (parser);
        }
        catch (Exception e) {
            throw new XException (e);
        }
    }
    
    /**
     * Method getResponse2
     *
     * @return   a String
     *
     */
    public String getResponse() {
        return lastResponse;
    }
    
    String getMessage() {
        return lastMessage;
    }
    
    /**
     * Method getInoIdList
     *
     * @return   a List
     *
     */
    /**
     * Method getInoIdList
     *
     * @return   a List
     *
     */
    public List getInoIdList () {
        return inoIds;
    }
    
    /**
     * SAX event handler. Reads the root element to determine the namespace URI.
     */
    class NameSpaceContentHandler extends DefaultHandler {
        
        StringBuffer msgBuf;
        
        /**
         * Called when an open element tag event is thrown.
         * Grab the relevant info.
         *
         * @param    namespaceURI        a  String
         * @param    localName           a  String
         * @param    qName               a  String
         * @param    atts                an Attributes
         *
         * @throws   SAXException
         *
         */
        public void startElement (String namespaceURI,
                                  String localName,
                                  String qName,
                                  Attributes atts)
            throws SAXException
        {
            msgBuf = new StringBuffer();
            if ("ino:message".equals (qName)) {
                String error = atts.getValue ("ino:returnvalue");
                lastResponse = error;
            }
                
            else if ("ino:object".equals (qName)) {
                inoIds.add (atts.getValue ("ino:id"));
            }
        }
        
        public void endElement (String namespaceURI,
                                String localName,
                                String qName) {
            
            if (qName.equals ("ino:messageline")) {
                lastMessage = msgBuf.toString();
            }
        }
        
        /**
         * reset the parser
         *
         */
        public void startDocument () {
            lastResponse = "";
            inoIds = new ArrayList ();
        }
        
        /**
         * do some consistency checks, everything here what expectes?
         *
         */
        public void endDocument () {
            
        }
        
        public void characters (char [] chars, int start, int len) {
            msgBuf.append (chars, start, len);
        }
    }
}

