/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/schema/KnownProperty.java,v 1.3 2004/07/30 06:51:56 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:56 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore.schema;

import org.jdom.Namespace;

/**
 * A known property is a property, for which we know some details as datatype,
 * which Tamino index should be used and so on. It will get an own entry in the
 * namespace specific schema.
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public interface KnownProperty {

    /**
     * Method getName
     *
     * @return   the name of this property
     *
     */
    String getName ();

    /**
     * Method getNamespace
     *
     * @return   the namespace of this property
     *
     */
    Namespace getNamespace();

    /**
     * Method getDataType
     *
     * @return   the datatype as defined in xs:schema (with prefix) i.e. xs:string
     *
     */
    String getDataType();

    /**
     * Method isTextIndexed
     *
     * @return   true if a text index shall be generated for this property
     *
     */
    boolean isTextIndexed ();

    /**
     * Method isStandardIndexed
     *
     * @return   true if a standard index shall be generated for this property
     *
     */
    boolean isStandardIndexed ();
}

