/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/schema/KnownPropertyList.java,v 1.3 2004/07/30 06:51:56 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:56 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;

import java.util.Iterator;
import java.util.Set;
import org.apache.slide.content.NodeProperty;
import org.jdom.Namespace;

/**
 * KnownPropertyList.java
 *
 * @author Created by Omnicore CodeGuide
 */

public interface KnownPropertyList {

    Iterator knownPropertyIterator (Namespace namespace);

    /**
     * Method getNamespaceIterator
     *
     * @return   iterator of the namespaces of all known properties
     *
     */
    Iterator getNamespaceIterator();

    /**
     * checks, if a NodeProperty is a known property
     *
     * @param    nodeProperty        a  NodeProperty
     *
     * @return   a boolean
     *
     */
    boolean isKnown (NodeProperty nodeProperty);

    /**
     * checks, if a property identified by name and namespace is a known
     * property.
     *
     * @param    name                a  String
     * @param    namespace           a  String
     *
     * @return   a boolean
     *
     */
    boolean isKnown (String name, String namespace);

    boolean isKnown (String name, Namespace ns);

    String getPrefix (String namespace);

}

