/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/schema/XSchemaType.java,v 1.3 2004/07/30 06:51:56 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:51:56 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;

// import list

/**
 ** This class defines constants for the different Tamino schema types.
 **
 ** @version $Revision: 1.3 $
 **
 ** @author rsk@softwareag.com
 **/
public class XSchemaType {
    /**
     ** the version string, i.e. TSD4 for TDS4
     **/
    private String versionString;

    /**
     ** String constant for <code>TSD</code>
     **/
    protected static final String TSD = "TSD";

    /**
     ** An array containing all supported schema types.
     **/
    protected static final XSchemaType[] SUPPORTED_TYPES = new XSchemaType[] {
        new XSchemaType("3"), new XSchemaType("4"), new XSchemaType("4.2")
    };

    /**
     ** Returns the XSchemaType for which the String returned by
     ** {@link #getVersionString getVersionString} equals the given
     ** <code>versionString</code>. If no matching XSchemaType is found,
     ** <code>null</code> is returned.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      versionString  the version String, e.g. <code>TSD2</code>.
     **
     ** @return     the XSchemaType for the given <code>versionString</code>.
     **/
    public static XSchemaType lookup(String versionString) {
        for (int i=0; i<SUPPORTED_TYPES.length; i++) {
            if (SUPPORTED_TYPES[i].getVersionString().equals(versionString)) {
                return SUPPORTED_TYPES[i];
            }
        }

        return null;
    }


    /**
     ** Creates an XSchemaType.
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      version  the version number of the Tamino schema, e.g. 2 for TSD2.
     **/
    public XSchemaType (String versionString) {
        this.versionString = TSD + versionString;
    }



    /**
     ** Returns the String representation of the TSD version which is
     ** e.g. <code>TSD2</code> for a version 2 schema.
     **
     ** @pre        true
     ** @post       true
     **
     ** @return     the String representation of the TSD version.
     **/
    public String getVersionString() {
        return versionString;
    }

    /**
     ** Returns a String representation of this schema type.
     **
     ** @pre        true
     ** @post       true
     **
     ** @return     a String representation of this schema type.
     **/
    public String toString() {
        return getVersionString();
    }
}

