/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/DescriptorsAdapter.java,v 1.1 2004/03/25 16:18:01 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:01 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.datastore.search;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.slide.store.tamino.common.IDescriptors;
import org.apache.slide.store.tamino.common.IDescriptorsHandler;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.util.XException;
import org.apache.slide.util.nodeset.Adapter;
import org.apache.slide.util.nodeset.NodeSet;

public class DescriptorsAdapter implements Adapter {
    private final IDescriptorsHandler handler;
    
    public DescriptorsAdapter(IDescriptorsHandler handler) {
        this.handler = handler;
    }
    
    public String getSeparator() {
        return "/";
    }
    public int getDefaultMinDepth() {
        return 0;
    }
    public int getDefaultMaxDepth() {
        return NodeSet.DEPTH_INFINITE;
    }
    
    public String getName(Object descriptorsNode) {
        return ((DescriptorsNode) descriptorsNode).name;
    }
    
    public Object[] getChildren(Object descriptorsNode) throws NodeSetException {
        DescriptorsNode node;
        IDescriptors desc;
        ObjectNode objectNode;
        Enumeration bindings;
        ObjectNode.Binding b;
        List lst;
        
        node = (DescriptorsNode) descriptorsNode;
        lst = new ArrayList();
        try {
            desc = node.get(handler);
        } catch (XException e) {
            throw new NodeSetException(e);
        }
        if (desc == null) {
            return Adapter.NO_CHILDREN;
        }
        objectNode = desc.getUuriObjectNode();
        bindings = objectNode.enumerateBindings();
        lst = new ArrayList();
        while (bindings.hasMoreElements()) {
            b = (ObjectNode.Binding) bindings.nextElement();
            lst.add(DescriptorsNode.createChild(node, b));
        }
        return lst.toArray();
    }
}

