/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/store/org/apache/slide/store/tamino/datastore/search/DescriptorsNode.java,v 1.1 2004/03/25 16:18:01 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:01 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.datastore.search;

import org.apache.slide.store.tamino.common.IDescriptors;
import org.apache.slide.store.tamino.common.IDescriptorsHandler;
import org.apache.slide.store.tamino.jdomobjects.XTLock;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;

public class DescriptorsNode {
    
    /** never starts with '/'; empty for root uri */
    public final String uri;
    
    /** last segment of uri **/
    public final String name;

    public final String uuri;

    /** loaded on demand */
    private IDescriptors desc;
    
    public static DescriptorsNode createRoot(String uri, String uuri) {
        XUri xuri;
        String uriStr;
        
        xuri = new XUri(uri);
        uriStr = xuri.suburi(0, xuri.size() - 1).toString();
        return new DescriptorsNode(uriStr.substring(1), xuri.lastSegment(), uuri);
    }
    public static DescriptorsNode createChild(DescriptorsNode parent, ObjectNode.Binding child) {
        return new DescriptorsNode(parent.uri, child.getName(), child.getUuri());
    }
    
    public DescriptorsNode(String parentUri, String name, String uuri) {
        if (parentUri.startsWith("/")) {
            throw new IllegalArgumentException (parentUri + " must not start with '/'");
        }
        if (parentUri.length() == 0) {
            this.uri = name;
        } else {
            this.uri = parentUri + "/" + name;
        }
        this.name = name;
        this.uuri = uuri;
        this.desc = null;
    }
    
    public String getUuri() {
        return uuri;
    }
    
    public IDescriptors get(IDescriptorsHandler handler) throws XException {
        if (desc == null) {
            desc = handler.lookup(uri, uuri, XTLock.NO_LOCK);
        }
        return desc;
    }
}



